using TMPro;
using UnityEngine;
using UnityEngine.UI;
using UnityEngine.XR.ARFoundation;

public class ARReadinessManager : MonoBehaviour
{
    [Header("UI")]
    public GameObject overlayUI;
    public Slider progressBar;
    public TMP_Text statusText;

    [Header("ImageTracking")]
    public GameObject markerScanner; // your tag/ar marker script

    [Header("Settings")]
    public float minReadyTime = 5f;

    private float elapsedTime = 0f;
    private bool trackingReady = false;

    void Start()
    {
        Screen.sleepTimeout = SleepTimeout.NeverSleep;
        markerScanner.SetActive(false);
        overlayUI.SetActive(true);
        progressBar.value = 0f;
        statusText.text = "Initializing AR...";
    }

    void Update()
    {
        // Track if AR is ready
        trackingReady = ARSession.state == ARSessionState.SessionTracking;

        if (trackingReady)
        {
            elapsedTime += Time.deltaTime;

            float progress = Mathf.Clamp01(elapsedTime / minReadyTime);
            progressBar.value = progress;

            if (progress >= 1f)
            {
                Ready();
            }
            else
            {
                statusText.text = $"Tracking stable. Preparing scanner... ({Mathf.Ceil(minReadyTime - elapsedTime)}s)";
            }
        }
        else
        {
            elapsedTime = 0f;
            progressBar.value = 0f;
            statusText.text = "Move your device to initialize AR tracking...";
        }
    }

    void Ready()
    {
        overlayUI.SetActive(false);
        markerScanner.SetActive(true);

        #if UNITY_ANDROID && !UNITY_EDITOR
            Handheld.Vibrate();
        #endif

        enabled = false; // disable this script
    }
}